/**                                                                       **/
/*************************************** GLOBAL VARIABLES & FUNCTIONS ******/
/**                                                                       **/

var attemptCount = 0;
var correctBoolean;
var atLeastOneCorrect;
var atLeastOneIncorrect;
var alphaArray = new Array();

function showFeedback() {
	var isFeedback = 'true';
	var isHint = 'true';
	document.getElementById("kc-feedback").style.display = "none";
	//Display feedback for 1st attempt
	if (attemptCount<2) {
		//Show correct feedback
		if (correctBoolean == 'true') {
			if (isFeedback == 'true') {
				var feedback = '';
				feedback = feedback + posFB;
				document.getElementById("kc-feedback").innerHTML=feedback;
				document.getElementById("kc-feedback").style.display = "block";
			}
			else {
				var feedback = '';
				feedback = feedback + posFB;
				document.getElementById("kc-feedback").innerHTML=feedback;
				document.getElementById("kc-feedback").style.display = "block";
			}
		}
		else {
			//Show partial correct  and partial incorrect feedback
			if (atLeastOneCorrect == 'true' && atLeastOneIncorrect == 'true') {
				document.getElementById("kc-feedback").innerHTML='You have selected both correct and incorrect responses. <br />Try again, ensuring that you select all correct responses.';
				document.getElementById("kc-feedback").style.display = "block";
			}
			else if (atLeastOneCorrect == 'true' && atLeastOneIncorrect == 'false') {
				document.getElementById("kc-feedback").innerHTML='You have selected some but not all of the correct responses. <br />Try again, ensuring that you select all correct responses.';
				document.getElementById("kc-feedback").style.display = "block";
			}
			//Show incorrect feedback
			else {
				if (isHint == 'true') {
					document.getElementById("kc-feedback").innerHTML='Not quite, try again!';
					document.getElementById("kc-feedback").style.display = "block";
				}
				else {
					document.getElementById("kc-feedback").innerHTML='Not quite, try again!';
					document.getElementById("kc-feedback").style.display = "block";
				}
			}
		}
	}
	//Display feedback for 2nd attempt
	else if (attemptCount==2) {
		if (correctBoolean == 'true') {
			if (isFeedback == 'true') {
				var feedback = '';
				feedback = feedback + posFB;
				document.getElementById("kc-feedback").innerHTML=feedback;
				document.getElementById("kc-feedback").style.display = "block";
			}
			else {
				var feedback = '';
				feedback = feedback + posFB;
				document.getElementById("kc-feedback").innerHTML=feedback;
				document.getElementById("kc-feedback").style.display = "block";
			}
		}
		else {
			if (isFeedback == 'true') {
				var feedback = '';
				feedback = feedback + negFB;
				document.getElementById("kc-feedback").innerHTML=feedback;
				document.getElementById("kc-feedback").style.display = "block";
			}
			else {
				var feedback = '';
				feedback = feedback + negFB;
				document.getElementById("kc-feedback").innerHTML=feedback;
				document.getElementById("kc-feedback").style.display = "block";
			}
		}
	}
	//Display feedback for 3rd (or more) attempts
	else {
		if (correctBoolean == 'true') {
			document.getElementById("kc-feedback").innerHTML="You have already completed this question.";
			document.getElementById("kc-feedback").style.display = "block";
		}
		else {
			document.getElementById("kc-feedback").innerHTML="You have already completed this question.";
			document.getElementById("kc-feedback").style.display = "block";
		}
	}
}

function resetform () {
	attemptCount = 0;
	document.kcform.reset();
	document.getElementById("kc-feedback").style.display = "none";
	for (i=1; i<=document.kcform.length; i++) {
		var elementID = "answerblock_"+(i);
		document.getElementById(elementID).style.background = "url(css/skin/kc-blank.gif) no-repeat left top";
	}
}

function incrementAttempts () {
	attemptCount++;
	return;
}


function initAlphaArray () {
	alphaArray[1] = 'A';
	alphaArray[2] = 'B';
	alphaArray[3] = 'C';
	alphaArray[4] = 'D';
	alphaArray[5] = 'E';
	alphaArray[6] = 'F';
	alphaArray[7] = 'G';
	alphaArray[8] = 'H';
	alphaArray[9] = 'I';
	alphaArray[9] = 'J';
}

/**                                                                       **/
/**************************************************** MULTIPLE CHOICE ******/
/**                                                                       **/

function check_KCMultiChoice() {
	document.getElementById("kc-feedback").innerHTML="";
	//First, check to ensure that they have checked a choice
	var userHasCheckedSomething = 'false';
	for (i=0; i<document.kcform.length; i++) {
		if (document.kcform.elements[i].checked) {
				userHasCheckedSomething = 'true';		
		}	
	}
	if (userHasCheckedSomething == 'false') {
		document.getElementById("kc-feedback").innerHTML="Please make a selection before clicking Check Your Answer.";
		document.getElementById("kc-feedback").style.display = "block";
	}
	//If they have selected at least one option, check the question
	else {
		incrementAttempts ();
		correctBoolean = 'true';
		var userAnswer;	
		//load userAnswer into a variable
		var userAnswerCount = 0;
		for (i=0;i<document.kcform.length;i++) {
			if (document.kcform.elements[i].checked) {
				userAnswer = document.kcform.elements[i].value;			
			}			
		}	
		//Check that no incorrect answers have been checked	
		for (i=0; i<document.kcform.length; i++) {
			if (userAnswer != correctAnswer) {
				correctBoolean = 'false';
			}
		}
		//showFeedback for 1st attempt
		if (attemptCount < 2) {
			//for each input element, put a blank image next to those that were not checked
			//and put and check or x next to the correct/incorrect response
			for (i=0; i<document.kcform.length; i++) {
				iPlus1 = i+1;
				if (iPlus1 == userAnswer) {
					var elementID = "answerblock_"+(iPlus1);
					if (correctBoolean == 'true') {
						document.getElementById(elementID).style.background = "url(css/skin/kc-correct.gif) no-repeat left top";
					}
					else {
						document.getElementById(elementID).style.background = "url(css/skin/kc-incorrect.gif) no-repeat left top";
					}
				}	
				else {
					var elementID = "answerblock_"+(iPlus1);
					document.getElementById(elementID).style.background = "url(css/skin/kc-blank.gif) no-repeat left top";
				}
			}		
		}
		//showFeedback for 2nd attempt
		else {
			for (i=1; i<=document.kcform.length; i++) {
				if (i != correctAnswer) {
					var elementID = "answerblock_"+(i);
					document.getElementById(elementID).style.background = "url(css/skin/kc-incorrect.gif) no-repeat left top";
				}
				else {
					var elementID = "answerblock_"+(i);
					document.getElementById(elementID).style.background = "url(css/skin/kc-correct.gif) no-repeat left top";
				}
			}
		}
		showFeedback();
	}
}

/**                                                                       **/
/******************************************* MULTIPLE-MULTIPLE CHOICE ******/
/**                                                                       **/

function check_KCMultiMultiChoice() {
	document.getElementById("kc-feedback").innerHTML="";
	//First, check to ensure that they have checked a choice
	var userHasCheckedSomething = 'false';
	for (i=0; i<document.kcform.length; i++) {
		if (document.kcform.elements[i].checked) {
				userHasCheckedSomething = 'true';		
		}	
	}
	if (userHasCheckedSomething == 'false') {
		document.getElementById("kc-feedback").innerHTML="Please make a selection before clicking Check Your Answer.";
		document.getElementById("kc-feedback").style.display = "block";
	}
	//If they have selected at least one option, check the question
	else {
		incrementAttempts ();
		correctBoolean = 'true';
		atLeastOneCorrect = 'false';
		atLeastOneIncorrect = 'false';
		var userAnswers = new Array();	
		//load userAnswers into Array
		var userAnswerCount = 0;
		for (i=0;i<document.kcform.length;i++) {
			if (document.kcform.elements[i].checked) {
				userAnswers[userAnswerCount] = document.kcform.elements[i].value;
				userAnswerCount++;				
			}			
		}	
		//Check that no incorrect answers have been checked	
		for (i=0; i<document.kcform.length; i++) {
			if (userAnswers[i] != correctAnswers[i]) {
				correctBoolean = 'false';
			}
		}
		
		//showFeedback for 1st attempt
		if (attemptCount < 2) {
			//for each input element, put a blank image next to those that were not checked
			//and put and check or x next to the correct/incorrect response
			for (i=0; i<document.kcform.length; i++) {
				iPlus1 = i+1;			
				if (document.kcform.elements[i].checked) {
					var elementID = "answerblock_"+(iPlus1);
					var localCorrectBoolean = 'false';
					//If checked, you must ensure that for document.kcform.elements[i], i is in the correctAnswers array
					//If i is not the correctAnswers
					for (j=0; j<correctAnswers.length; j++) {
						if (document.kcform.elements[i].value == correctAnswers[j]) {
							localCorrectBoolean = 'true';
						}
					}
					if (localCorrectBoolean == 'true') {
						document.getElementById(elementID).style.background = "url(css/skin/kc-correct.gif) no-repeat left top";
						atLeastOneCorrect = 'true';
					}
					else {
						document.getElementById(elementID).style.background = "url(css/skin/kc-incorrect.gif) no-repeat left top";
						atLeastOneIncorrect = 'true';
					}
				}	
				else {
					var elementID = "answerblock_"+(iPlus1);
					document.getElementById(elementID).style.background = "url(css/skin/kc-blank.gif) no-repeat left top";
				}			
			}		
		}
		//showFeedback for 2nd attempt
		else {
			for (i=0; i<document.kcform.length; i++) {
				iPlus1 = i+1;			
				var elementID = "answerblock_"+(iPlus1);
				var localCorrectBoolean = 'false';
				//If checked, you must ensure that for document.kcform.elements[i], i is in the correctAnswers array
				//If i is not the correctAnswers 
				for (j=0; j<correctAnswers.length; j++) {
					if (document.kcform.elements[i].value == correctAnswers[j]) {
						localCorrectBoolean = 'true';
					}
				}
				if (localCorrectBoolean == 'true') {
					document.getElementById(elementID).style.background = "url(css/skin/kc-correct.gif) no-repeat left top";
				}
				else {
					document.getElementById(elementID).style.background = "url(css/skin/kc-blank.gif) no-repeat left top";
				}		
			}		
		}	
		showFeedback();
	}
}

/**                                                                       **/
/**************************************************** MATCHING CHOICE ******/
/**                                                                       **/

function check_KCMatching() {
	document.getElementById("kc-feedback").innerHTML="";
	//First, check to ensure that they have checked a choice
	var userHasCheckedSomething = 'false';
	for (i=0; i<document.kcform.length; i++) {
		if (document.getElementById('select_'+(i+1)).selectedIndex != 0) {
				userHasCheckedSomething = 'true';		
		}	
	}
	if (userHasCheckedSomething == 'false') {
		document.getElementById("kc-feedback").innerHTML="Please make a selection before clicking Check Your Answer.";
		document.getElementById("kc-feedback").style.display = "block";
	}
	//If they have selected at least one option, check the question
	else {
		document.getElementById("kc-feedback").innerHTML="";
		incrementAttempts ();
		correctBoolean = 'true';
		atLeastOneCorrect = 'false';
		atLeastOneIncorrect = 'false';
		var userAnswers = new Array();	
		//load userAnswers into Array
		for (i=0;i<document.kcform.length;i++) {
			userAnswers[i] = document.getElementById('select_'+(i+1)).selectedIndex;
		}	
		//Check that no incorrect answers have been checked
		for (i=0; i<document.kcform.length; i++) {
			if (userAnswers[i] != correctAnswers[i]) {
				//alert ('userAnswers[' + i + '] = ' + userAnswers[i] + ', correctAnswers[' + i + '] = ' + correctAnswers[i]);
				correctBoolean = 'false';
			}
		}	
		
		for (i=0; i<document.kcform.length; i++) {
			iPlus1 = i+1;			
			var elementID = "answerblock_"+(iPlus1);
			var localCorrectBoolean = 'false';
			//If checked, you must ensure that for document.kcform.elements[i], i is in the correctAnswers array
			//If i is not the correctAnswers 
			if (userAnswers[i] == correctAnswers[i]) {
				localCorrectBoolean = 'true';
			}
			if (localCorrectBoolean == 'true') {
				document.getElementById(elementID).style.background = "url(css/skin/kc-correct.gif) no-repeat left top";
				atLeastOneCorrect = 'true';
			}
			else {
				document.getElementById(elementID).style.background = "url(css/skin/kc-incorrect.gif) no-repeat left top";
				atLeastOneIncorrect = 'true';
				// Show the correct answer for incorrect choices
				if (attemptCount==2) {
					document.getElementById('select_'+(i+1)).selectedIndex = correctAnswers[i];
				}
			}		
		}				
		showFeedback();
	}
}

